<?php

// Register Custom Navigation Walker
require_once get_template_directory() . '/class-wp-bootstrap-navwalker.php';

// Theme Setup
function wpbasics_theme_setup() {
	//Nav Menus
	register_nav_menus( array(
		'primary' => __( 'Primary Menu')
	) );
}

add_action('after_setup_theme', 'wpbasics_theme_setup');

function add_theme_scripts() {
	wp_enqueue_style('marketwiz_styles', get_template_directory_uri() . '/assets/libs/@fortawesome/fontawesome-free/css/all.min.css');
	wp_enqueue_script('core_js', get_template_directory_uri() . '/assets/js/purpose.core.js', array(), '6.0.0', true);
	wp_enqueue_script('marketwiz_js', get_template_directory_uri() . '/assets/js/purpose.js', array(), '6.0.0', true);
}

add_action( 'wp_enqueue_scripts', 'add_theme_scripts' );

function add_fancybox_styles_contact() {
	if ( is_page_template( 'contact_us.php') ) {
		wp_enqueue_style( 'fancybox', get_template_directory_uri() . '/assets/libs/@fancyapps/fancybox/dist/jquery.fancybox.min.css' );
	}
}
add_action( 'wp_enqueue_scripts', 'add_fancybox_styles_contact' );