<?php /* Template Name: Contact Us Page */ ?>
<?php get_header(); get_template_part('wiz_menu') ?>
<div class="main-content">
	<section class="slice bg-primary pb-250" data-offset-top="#header-main">
		<!-- SVG background -->
		<div class="bg-absolute-cover bg-size--contain d-flex align-items-center">
			<figure class="w-100 d-none d-lg-block">
				<img alt="Image placeholder" src="<?php bloginfo('template_url');?>/assets/img/svg/backgrounds/bg-3.svg" class="svg-inject">
			</figure>
		</div>
		<div class="container py-5 pt-lg-6 position-relative zindex-100">
			<div class="row">
				<div class="col-lg-5">
					<h1 class="text-white">Have a project in mind?</h1>
					<p class="lead text-white mt-4">We put all the experience and know-how in this product so we can offer you the best product we have ever built.</p>
					<a href="#sct_contact_form" class="btn btn-secondary rounded-pill btn-icon hover-translate-y-n3 mt-4" data-scroll-to data-scroll-to-offset="140">
						<span class="btn-inner--icon"><i class="fas fa-pencil-alt"></i></span>
						<span class="btn-inner--text">Write a message</span>
					</a>
				</div>
			</div>
		</div>
	</section>
	<section class="slice slice-lg pt-lg-5">
		<div class="container position-relative zindex-100">
			<div class="row mt--200">
				<div class="col-lg-6 float-right ml-auto">
					<div class="card bg-dark opacity-container text-white overflow-hidden shadow border-0">
						<a href="#" data-fancybox data-type="iframe" data-src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d369106.7267949492!2d-79.65824079514913!3d43.71789901030551!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x89d4cb90d7c63ba5%3A0x323555502ab4c477!2sToronto%2C+ON%2C+Canada!5e0!3m2!1sen!2ses!4v1563491576125!5m2!1sen!2ses">
							<div class="card-img-bg" style="background-image: url('<?php bloginfo('template_url');?>/assets/img/theme/light/city-2.jpg');"></div>
							<span class="mask bg-gradient-dark opacity-9 opacity-8--hover"></span>
							<div class="card-body px-5 py-5">
								<div style="min-height: 250px;">
									<h2 class="h2 text-white font-weight-bold mb-4">Toronto</h2>
									<h5 class="text-white mt-4 mb-2">E: info@marketwiz.ca</h5>
									<h5 class="text-white">T: (437) 777-4780</h5>
								</div>
								<span class="text-white text-uppercase font-weight-bold">
                    See on map
                    <i class="fas fa-angle-right ml-2"></i>
                  </span>
							</div>
						</a>
					</div>
				</div>
			</div>
		</div>
	</section>
	<section id="sct_contact_form" class="slice slice-lg" data-delimiter-before="1">
		<div class="container">
			<div class="row row-grid align-items-center">
				<div class="col-lg-6">
					<h3>Contact us</h3>
					<p class="lead">If there's something we can help you with, jut let us know. We'll be more than happy to offer you our help</p>
					<form class="mt-5">
						<div class="form-group">
							<label class="sr-only">Your name</label>
							<input class="form-control form-control-lg" placeholder="Your name" type="text">
						</div>
						<div class="form-group">
							<label class="sr-only">Email address</label>
							<input class="form-control form-control-lg" placeholder="Email address" type="text">
						</div>
						<div class="form-group">
							<label class="sr-only">Type your message</label>
							<textarea class="form-control form-control-lg textarea-autosize" rows="5" placeholder="Type your message"></textarea>
						</div>
						<button type="submit" class="btn btn-dark rounded-pill mt-4">Send message</button>
					</form>
				</div>
				<div class="col-lg-5 ml-lg-auto">
					<h3>150 Southeast Pidgeon Meadow<br>Claflin Terrace, 305458</h3>
					<p class="lead my-4">E: <a href="#">support@webpixels.io</a><br>T: 0755.222.333</p>
					<p>Purpose is a complete responsive HTML5 Template based on Bootstrap 4 made for Agency, Startup, Business, Finance, Consulting, Real Estate, Recruitment, Travel website and not only.</p>
				</div>
			</div>
		</div>
	</section>
	<!-- Call to action (v5) -->
	<section class="slice slice-lg bg-section-secondary" id=sct-call-to-action><a href="#sct-call-to-action" class="tongue tongue-up tongue-section-primary" data-scroll-to>
			<i class="fas fa-angle-up"></i>
		</a>
		<div class="container">
			<div class="row justify-content-center align-items-center">
				<div class="col-lg-8 text-center">
					<h3 class="font-weight-400">I am ready to start a new project with <span class="font-weight-700">Purpose</span> UI Kit.</h3>
					<div class="mt-5">
						<a href="https://themes.getbootstrap.com/product/purpose-website-ui-kit/" class="btn btn-primary rounded-pill hover-translate-y-n3">
							Purchase now<span class="badge badge-pill badge-soft-warning badge-floating border-section-secondary">$ 59</span>
						</a>
						<a href="/marketwiz" class="btn btn-link" data-toggle="tooltip" data-placement="bottom" title="Official documentation">Purpose Docs</a>
					</div>
				</div>
			</div>
		</div>
	</section>
</div>
<?php get_footer(); ?>
<!-- Page JS -->
<script src="<?php bloginfo('template_url');?>/assets/libs/autosize/dist/autosize.min.js"></script>
<script src="<?php bloginfo('template_url');?>/assets/libs/@fancyapps/fancybox/dist/jquery.fancybox.min.js"></script>
</body>

</html>
